<?php
/**
 * The header for Astra Theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Astra
 * @since 1.0.0
 */

?><!DOCTYPE html>
<?php astra_html_before(); ?>
<html <?php language_attributes(); ?>>
<head>
<?php astra_head_top(); ?>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">

<?php astra_head_bottom(); ?>
<?php wp_head(); ?>

  <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
  <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>

<script>

/* French initialisation for the jQuery UI date picker plugin. */
/* Written by Keith Wood (kbwood{at}iinet.com.au) and Stphane Nahmani (sholby@sholby.net). */
jQuery(function($){
	$.datepicker.regional['fr'] = {
		closeText: 'Fermer',
		prevText: '&#x3c;Prc',
		nextText: 'Suiv&#x3e;',
		currentText: 'Aujourd\'hui',
		monthNames: ['Janvier','Fevrier','Mars','Avril','Mai','Juin',
		'Juillet','Aout','Septembre','Octobre','Novembre','Decembre'],
		monthNamesShort: ['Jan','Fev','Mar','Avr','Mai','Jun',
		'Jul','Aou','Sep','Oct','Nov','Dec'],
		dayNames: ['Dimanche','Lundi','Mardi','Mercredi','Jeudi','Vendredi','Samedi'],
		dayNamesShort: ['Dim','Lun','Mar','Mer','Jeu','Ven','Sam'],
		dayNamesMin: ['Di','Lu','Ma','Me','Je','Ve','Sa'],
		weekHeader: 'Sm',
		dateFormat: 'dd-mm-yy',
		firstDay: 1,
		isRTL: false,
		showMonthAfterYear: false,
		yearSuffix: '',
		minDate: 0,
		maxDate: '+12M +0D',
		numberOfMonths: 1,
		showButtonPanel: true
		};
	$.datepicker.setDefaults($.datepicker.regional['fr']);


$( document ).ready(function() {
  $( ".calendrier input.wpcf7-form-control.wpcf7-text.wpcf7-validates-as-required" ).datepicker( $.datepicker.regional[ "fr" ] );
});

$('div.msg-med-box').hide();
$(".motifinsc span.wpcf7-list-item.last input").click(function(){
if( $('.motifinsc span.wpcf7-list-item.last input').is(':checked') ){
    $('div.msg-med-box').show();
    $('textarea.msg-med').val('');
    $('div.msg-box').hide();
} else {
    $('div.msg-med-box').hide();
    $('textarea.msg-med').val('-');
    $('div.msg-box').show();

}
});

$('div#don-step2').hide();
$("div#don-btn-confirm").click(function(){
	$('div#don-step2').show();
    $('html, body').animate({
         scrollTop: $("#don-step2").offset().top
    }, 500);	
});


$("#don-button").click(function(){

if($('.wpcf7-validation-errors').length != 0){
	$("#don-step1").append("<br/><br/><strong class='depot-ok'>Merci, nous vous attendons 9 rue Edouard Pailleron 75019 Paris, du lundi au jeudi de 8 h a 18 h, le vendredi de 9 h a 14 h et le dimanche de 10 h a 14 h.</strong>");
    $('html, body').animate({
         scrollTop: $("#don-step1").offset().top
    }, 500);
	$('div#don-step2').hide();
}

});

var rand_Number = Math.random().toString(36).replace(/[^a-z]+/g, '').substr(0, 10);
$('#random-transaction').val(rand_Number);
$('#random-transaction-sujet').val(rand_Number);


});




</script>
</head>

<body <?php astra_schema_body(); ?> <?php body_class(); ?>>

<?php astra_body_top(); ?>
<div id="page" class="hfeed site">
	<a class="skip-link screen-reader-text" href="#content"><?php echo esc_html( astra_default_strings( 'string-header-skip-link', false ) ); ?></a>

	<?php astra_header_before(); ?>

	<?php astra_header(); ?>

	<?php astra_header_after(); ?>

	<?php astra_content_before(); ?>

	<div id="content" class="site-content">

		<div class="ast-container">

		<?php astra_content_top(); ?>
