<?php

class Wordpress_CF7_PayPal_Admin
{
    private $plugin_name;
    private $version;
    private $options;

    /**
     * Construct CF7 PayPal Admin Class
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @param   string                         $plugin_name
     * @param   string                         $version    
     */
    public function __construct($plugin_name, $version)
    {
        $this->plugin_name = $plugin_name;
        $this->version = $version;
    }

    /**
     * Load Extensions
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  boolean
     */
    public function load_extensions()
    {
        // Load the theme/plugin options
        if (file_exists(plugin_dir_path(dirname(__FILE__)).'admin/options-init.php')) {
            require_once plugin_dir_path(dirname(__FILE__)).'admin/options-init.php';
        }
    }

    /**
     * Get Options
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @param   mixed                         $option The option key
     * @return  mixed                                 The option value
     */
    private function get_option($option)
    {
        if(!is_array($this->options)) {
            return false;
        }

        if (!array_key_exists($option, $this->options)) {
            return false;
        }

        return $this->options[$option];
    }

    /**
     * Init Admin facade
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  [type]                         [description]
     */
    public function init()
    {
        global $Wordpress_CF7_PayPal_options;

        $this->options = $Wordpress_CF7_PayPal_options;

        if (!$this->get_option('enable')) {
            return false;
        }
    }

    /**
     * Add the Transactions Menu Page
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     */
    public function plugin_menu() {

        $hook = add_submenu_page(
            'wpcf7',
            'PayPal Transactions',
            'PayPal Transactions',
            'manage_options',
            'cf7-paypal-transactions',
            array( $this, 'plugin_settings_page')
        );
    }

    /**
     * Plugin settings page
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  
     */
    public function plugin_settings_page() {

        $plugin_transactions = new Wordpress_CF7_PayPal_Transaction();
        $plugin_transactions->prepare_items();
        ?>
        <div class="wrap">
            <h2>CF7 PayPal Transactions</h2>

            <div id="poststuff">
                <div id="post-body" class="metabox-holder">
                    <div id="post-body-content">
                        <div class="meta-box-sortables ui-sortable">
                            <form method="post">
                                <?php
                                $plugin_transactions->display(); ?>
                            </form>
                        </div>
                    </div>
                </div>
                <br class="clear">
            </div>
        </div>
    <?php
    }

    /**
     * Add PayPal tag generator
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  string
     */
    public function wpcf7_add_tag_generator_paypal()
    {
        wpcf7_add_tag_generator( 
            'paypal', __( 'PayPal Button', 'wordpress-cf7-paypal' ), 
            array($this, 'wpcf7_tag_generator_paypal'),  
            array($this, 'wpcf7_tag_generator_paypal') 
        );
    }

    /**
     * Configure the PayPal Tag Generator settings
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  string
     */
    public function wpcf7_tag_generator_paypal() 
    {
        $description = __( "Generate a form-tag for a paypal button. For more details, see %s.", 'wordpress-cf7-paypal' );

        $desc_link = wpcf7_link( __( 'http://contactform7.com/paypal-button/', 'wordpress-cf7-paypal' ), __( 'PayPal Button', 'wordpress-cf7-paypal' ) );

        ?>
        <div class="control-box">
            <fieldset>
            <legend><?php echo sprintf( esc_html( $description ), $desc_link ); ?></legend>

            <table class="form-table">
                <tbody>

                    <!-- Value -->
                    <tr>
                        <th scope="row">
                            <label for="values">
                                <?php echo esc_html( __( 'Label', 'wordpress-cf7-paypal' ) ); ?>
                            </label>
                        </th>
                        <td>    
                            <input type="text" name="values" class="oneline" id="values" />
                        </td>
                    </tr>
                    
                    <!-- Return URL -->
                    <tr>
                        <th scope="row">
                            <label for="return">
                                <?php echo esc_html( __( 'Paypment successfull Redirect URL', 'wordpress-cf7-paypal' ) ); ?>
                            </label>
                        </th>
                        <td>    
                            <input type="text" name="return" class="return oneline option" id="return" />
                        </td>
                    </tr>

                    <!-- Cancel URL -->
                    <tr>
                        <th scope="row">
                            <label for="cancel_return">
                                <?php echo esc_html( __( 'Paypment cancelled Redirect URL', 'wordpress-cf7-paypal' ) ); ?>
                            </label>
                        </th>
                        <td>    
                            <input type="text" name="cancel_return" class="cancel_return oneline option" id="cancel_return" />
                        </td>
                    </tr>
                    
                    <!-- Custom CSS Class -->
                    <tr>
                        <th scope="row">
                            <label for="class">
                                <?php echo esc_html( __( 'Class attribute', 'wordpress-cf7-paypal' ) ); ?>
                            </label>
                        </th>
                        <td>    
                            <input type="text" name="class" class="classvalue oneline option" id="class" />
                        </td>
                    </tr>

                </tbody>
            </table>

            </fieldset>
        </div>

        <div class="insert-box">
            <input type="text" name="paypal" class="tag code" readonly="readonly" onfocus="this.select()" />

            <div class="paypalbox">
            <input type="button" class="button button-primary insert-tag" value="<?php echo esc_attr( __( 'Insert Tag', 'wordpress-cf7-paypal' ) ); ?>" />
            </div>
        </div>
        <?php
    }

}