<?php

class Wordpress_CF7_PayPal_Transaction extends WP_List_Table {

    /**
     * Constructor
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     */
	public function __construct() {

		parent::__construct( 
			
			array(	
				'singular' => __( 'PayPal Transaction', 'wordpress-cf7-paypal' ), //singular name of the listed records
				'plural'   => __( 'PayPal Transactions', 'wordpress-cf7-paypal' ), //plural name of the listed records
				'ajax'     => false //should this table support ajax?
			)
		);
		add_action( "load-contact_page_cf7-paypal-transactions", array( $this, 'screen_option' ) );
		add_filter( 'set-screen-option', array($this, 'set_screen'), 10, 3 );
	}

    /**
     * Set Screen
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  string
     */
	public static function set_screen( $status, $option, $value ) {
		return $value;
	}

    /**
     * Screen options
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  
     */
	public function screen_option() {

		$option = 'per_page';
		$args   = array(
			'label'   => 'Transactions',
			'default' => 25,
			'option'  => 'transactions_per_page'
		);

		add_screen_option( $option, $args );
	}

    /**
     * Retrieve transactions data from the database
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  array
     */
	public function get_transactions( $per_page = 25, $page_number = 1 ) {

		global $wpdb;
		global $Wordpress_CF7_PayPal_options;

		if(!isset($Wordpress_CF7_PayPal_options['paypalAPIUser']) || empty($Wordpress_CF7_PayPal_options['paypalAPIUser'])) {
			echo '	<div id="setting-error-tgmpa" class="notice-error notice is-dismissible"> 
				<p><strong>' . __('Can not fetch PayPal real live data!', 'wordpress-cf7-paypal') . '</strong></p>
				<p><strong>' . __('Please make sure you have set your PayPal API Username!', 'wordpress-cf7-paypal') . '</strong></p>
				<button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>
			</div>';
			return false;
		}

		if(!isset($Wordpress_CF7_PayPal_options['paypalAPIPassword']) || empty($Wordpress_CF7_PayPal_options['paypalAPIPassword'])) {
			echo '	<div id="setting-error-tgmpa" class="notice-error notice is-dismissible"> 
				<p><strong>' . __('Can not fetch PayPal real live data!', 'wordpress-cf7-paypal') . '</strong></p>
				<p><strong>' . __('Please make sure you have set your PayPal API Password!', 'wordpress-cf7-paypal') . '</strong></p>
				<button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>
			</div>';
			return false;
		}

		if(!isset($Wordpress_CF7_PayPal_options['paypalAPISignature']) || empty($Wordpress_CF7_PayPal_options['paypalAPISignature'])) {
			echo '	<div id="setting-error-tgmpa" class="notice-error notice is-dismissible"> 
				<p><strong>' . __('Can not fetch PayPal real live data!', 'wordpress-cf7-paypal') . '</strong></p>
				<p><strong>' . __('Please make sure you have set your PayPal API Signature!', 'wordpress-cf7-paypal') . '</strong></p>
				<button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>
			</div>';
			return false;
		}

		$user = $Wordpress_CF7_PayPal_options['paypalAPIUser'];
		$password = $Wordpress_CF7_PayPal_options['paypalAPIPassword'];
		$signature = $Wordpress_CF7_PayPal_options['paypalAPISignature'];

    	$paypal_url = "https://api-3t.sandbox.paypal.com/nvp";
    	if($Wordpress_CF7_PayPal_options['sandbox'] === "0") {
    		$paypal_url = "https://api-3t.paypal.com/nvp";
    	}

		 $info = 'USER=' . $user
		    .'&PWD=' . $password
		    .'&SIGNATURE=' . $signature
		    .'&METHOD=TransactionSearch'
		    .'&TRANSACTIONCLASS=RECEIVED'
		    .'&STARTDATE=2013-01-08T05:38:48Z'
		    .'&ENDDATE=' . str_replace('+00:00', 'Z', gmdate('c'))
		    .'&VERSION=94';

		$curl = curl_init($paypal_url);
		curl_setopt($curl, CURLOPT_FAILONERROR, true);
		curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

		curl_setopt($curl, CURLOPT_POSTFIELDS,  $info);
		curl_setopt($curl, CURLOPT_HEADER, 0);
		curl_setopt($curl, CURLOPT_POST, 1);

		$result = curl_exec($curl);

		# Bust the string up into an array by the ampersand (&)
	 	# You could also use parse_str(), but it would most likely limit out
	 	$result = explode("&", $result);

		# Loop through the new array and further bust up each element by the equal sign (=)
		# and then create a new array with the left side of the equal sign as the key and the       right side of the equal sign as the value
	   foreach($result as $value){
			$value = explode("=", $value);
			$temp[$value[0]] = $value[1];
		}

		$transactions = array();
		for($i=0; $i<(count($temp)/11)-1; $i++){
		    $transactions[$i] = array(
			    "timestamp"         =>    urldecode($temp["L_TIMESTAMP".$i]),
			    "timezone"          =>    urldecode($temp["L_TIMEZONE".$i]),
			    "type"              =>    urldecode($temp["L_TYPE".$i]),
			    "email"             =>    urldecode($temp["L_EMAIL".$i]),
			    "name"              =>    urldecode($temp["L_NAME".$i]),
			    "txn_id"    		=>    urldecode($temp["L_TRANSACTIONID".$i]),
			    "status"            =>    urldecode($temp["L_STATUS".$i]),
			    "amt"               =>    urldecode($temp["L_AMT".$i]),
			    "currency_code"     =>    urldecode($temp["L_CURRENCYCODE".$i]),
			    "fee_amount"        =>    urldecode($temp["L_FEEAMT".$i]),
			    "net_amount"        =>    urldecode($temp["L_NETAMT".$i])
		    );

			$transactions[$i]['date'] = $transactions[$i]['timestamp'];
			$transactions[$i]['customer'] = $transactions[$i]['name'] . '<br/> ' . $transactions[$i]['email'];
			// $transactions[$i]['items'] = '';
			$transactions[$i]['payment_status'] = $transactions[$i]['status'];
			$transactions[$i]['payment_net'] = $transactions[$i]['net_amount'] . ' ' . $transactions[$i]['currency_code'];		
		}

		if(empty($transactions)) {
			echo '	<div id="setting-error-tgmpa" class="notice-error notice is-dismissible"> 
				<p><strong>' . __('No Transactions found.', 'wordpress-cf7-paypal') . '</strong></p>
				<button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>
			</div>';
			return false;
		}

    	return $transactions;
	}

    /**
     * Reorder PayPal response
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  array
     */
	public function reorder_paypal_response( $response ) {
	    // Remove SUCCESS part (7 characters long)
		$response = substr($response, 7);


		// URL decode
		$response = urldecode($response);

		// Turn into associative array
		preg_match_all('/^([^=\s]++)=(.*+)/m', $response, $m, PREG_PATTERN_ORDER);
		$response = array_combine($m[1], $m[2]);

		// Fix character encoding if different from UTF-8 (in my case)
		if(isset($response['charset']) AND strtoupper($response['charset']) !== 'UTF-8')
		{
			foreach($response as $key => &$value)
			{
				$value = mb_convert_encoding($value, 'UTF-8', $response['charset']);
			}

			$response['charset_original'] = $response['charset'];
			$response['charset'] = 'UTF-8';
		}

		// Sort on keys for readability (handy when debugging)
		ksort($response);

		return $response;
	}

	private function fetch_transaction_details($transaction_id)
	{
		global $Wordpress_CF7_PayPal_options;

		$identity = $Wordpress_CF7_PayPal_options['paypalIdentity'];
    	$paypal_url = "https://www.sandbox.paypal.com/cgi-bin/webscr";
    	if($Wordpress_CF7_PayPal_options['sandbox'] === "0") {
    		$paypal_url = "https://www.paypal.com/cgi-bin/webscr";
    	}

		$ch = curl_init(); 
		// Set request options 
		curl_setopt_array($ch, array ( CURLOPT_URL => $paypal_url,
			CURLOPT_POST => TRUE,
			CURLOPT_POSTFIELDS => http_build_query(array
			(
				'cmd' => '_notify-synch',
				'tx' => $paymentId,
				'at' => $identity,
			)),
			CURLOPT_RETURNTRANSFER => TRUE,
			CURLOPT_HEADER => FALSE,
		));

		$response = curl_exec($ch);
		$status   = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		
		if($status == 200 AND strpos($response, 'SUCCESS') === 0)
		{
			$response = $this->reorder_paypal_response($response);

			$transaction['customer'] .= $this->get_customer_column($response);

			$transaction['items'] = "";
			if(!empty($response['num_cart_items']) && $response['num_cart_items'] > 0) {
				for ($i=1; $i <= $response['num_cart_items']; $i++) { 
					$transaction['items'] .= '<b>' . __('Item:', 'wordpress-cf7-paypal') . $i . '</b> ' . 
										$response['item_name' . $i] . ' (' . __('SKU:','wordpress-cf7-paypal') . $response['item_number' . $i] . ')<br/>';
					$transaction['items'] .= '<b>' . __('Quantity:', 'wordpress-cf7-paypal') . '</b> ' . 
										$response['quantity' . $i] . '<br/>';
					$transaction['items'] .= '<b>' . __('Price:', 'wordpress-cf7-paypal') . '</b> ' . 
										$response['mc_gross_' . $i] / $response['quantity' . $i] . ' ' . $response['mc_currency'] . '<br/>';
					$transaction['items'] .= '<br/>';
				}
			}

			$transaction['payment_status'] = $response['payment_status'];
			$transaction['payment_gross'] = $response['mc_gross']. ' ' . $response['mc_currency'] . '<br/>';
			$transaction['payment_gross'] .= '<b>' . __('Transaction fee:', 'wordpress-cf7-paypal') . '</b> ' . $response['mc_fee'] . ' ' . $response['mc_currency'] . '<br/>';
			$transaction['payment_gross'] .= '<b>' . __('Handling fee:', 'wordpress-cf7-paypal') . '</b> ' . $response['mc_handling'] . ' ' . $response['mc_currency'] . '<br/>';
			$transaction['payment_gross'] .= '<b>' . __('Shipping fee:', 'wordpress-cf7-paypal') . '</b> ' . $response['mc_shipping'] . ' ' . $response['mc_currency'] . '<br/>';

			$transaction['date'] = $response['payment_date'];

			// Not needed infos until now
			  // ["payment_type"]=>
			  // string(7) "instant"
			  // ["protection_eligibility"]=>
			  // string(8) "Eligible"


			  // ["receiver_id"]=>
			  // string(13) "G4E9NWWZG6NNA"
			  // ["residence_country"]=>
			  // string(2) "DE"
			  // ["settle_amount"]=>
			  // string(5) "86.17"
			  // ["settle_currency"]=>
			  // string(3) "EUR"
			  // ["tax"]=>
			  // string(4) "0.00"
			  // ["tax1"]=>
			  // string(4) "0.00"
		} else {
			var_dump($paymentId);
			var_dump($status);
			var_dump($response);
		}
		curl_close($ch);
	}

    /**
     * Get the Customer Column
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  string
     */
	public function get_customer_column($response)
	{
		$customer = 
		'<b>' . __('Name:', 'wordpress-cf7-paypal') . '</b> ' . 
		$response['address_name'] . ' (' . $response['payer_email'] . ')<br/>

		<b>' . __('Street:', 'wordpress-cf7-paypal') . '</b> ' . 
		$response['address_street'] . '<br/>

		<b>' . __('ZIP, City:', 'wordpress-cf7-paypal') . '</b> ' . 
		$response['address_zip'] . ', ' . $response['address_city'] . '<br/>

		<b>' . __('State:', 'wordpress-cf7-paypal') . '</b> ' . 
		$response['address_state'] . '<br/>

		<b>' . __('Country:', 'wordpress-cf7-paypal') . '</b> ' . 
		$response['address_country'] . ' (' . $response['address_country_code'] . ') <br/>

		<b>' . __('Customer Status:', 'wordpress-cf7-paypal') . '</b> ' . 
		$response['payer_status'] . '<br/>	

		<b>' . __('Address Status:', 'wordpress-cf7-paypal') . '</b> ' . 
		$response['address_status'] . '<br/>';

		return $customer;
	}

    /**
     * Text displayed when no transaction data is available 
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  array
     */
	public function no_items() {
		_e( 'No transactions avaliable.', 'wordpress-cf7-paypal' );
	}

    /**
     * Render a column when no column specific method exist.
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  array
     */
	public function column_default( $item, $column_name ) {
		switch ( $column_name ) {
			case 'date':
			case 'txn_id':
			// case 'items':
			case 'customer':
			case 'payment_net':
			case 'payment_status':
				return $item[ $column_name ];
			case 'currency_code':
				return false;
			default:
				return $item[ $column_name ]; //Show the whole array for troubleshooting purposes
		}
	}

    /**
     * Get the Column name
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  array
     */
	public function column_name( $item ) {

		$delete_nonce = wp_create_nonce( 'cf7_paypal_delete_transaction' );

		$title = '<strong>' . $item['name'] . '</strong>';

		$actions = array(
			'delete' => sprintf( '<a href="?page=%s&action=%s&transaction=%s&_wpnonce=%s">Delete</a>', esc_attr( $_REQUEST['page'] ), 'delete', absint( $item['id'] ), $delete_nonce )
		);

		return $title . $this->row_actions( $actions );
	}

    /**
     * Get the Columns
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  array
     */
	public function get_columns() {
		$columns = array(
			'date' => __('Payment date', 'wordpress-cf7-paypal'),
			'txn_id' => __('Transaction id', 'wordpress-cf7-paypal'),
			'customer' => __('Customer', 'wordpress-cf7-paypal'),
			// 'items' => __('Items', 'wordpress-cf7-paypal'),
			'payment_net' => __('Net Amount', 'wordpress-cf7-paypal'),
			'payment_status' => __('Payment Status', 'wordpress-cf7-paypal'),
		);

		return $columns;
	}

    /**
     * Get the Sortable columns
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  array
     */
	public function get_sortable_columns() {
		$sortable_columns = array(
			'date' => array ('date', true),
			'txn_id' => array ('txn_id', true),
			'customer' => array ('customer', false),
			// 'items' => array ('items', true),
			'payment_net' => array ('payment_net', true),
			// 'currency_code' => array ('currency_code', true),
			'payment_status' => array ('payment_status', true),
		);

		return $sortable_columns;
	}

    /**
     * Prepare your items
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  mixed
     */
	public function prepare_items() {

        $columns = $this->get_columns();
        $hidden = $this->get_hidden_columns();
        $sortable = $this->get_sortable_columns();

		$this->_column_headers = array($columns, $hidden, $sortable);

		$per_page     = $this->get_items_per_page( 'transactions_per_page', 25 );
		$current_page = $this->get_pagenum();
		$total_items  = self::record_count();

		$this->set_pagination_args( array(
			'total_items' => $total_items, //WE have to calculate the total number of items
			'per_page'    => $per_page //WE have to determine how many items to show on a page
		));

		$this->items = self::get_transactions( $per_page, $current_page );
	}

    /**
     * Define which columns are hidden
     *
     * @return Array
     */
    public function get_hidden_columns()
    {
        return array();
    }

}