<?php

/**
 * The plugin bootstrap file
 *
 *
 * @link              https://welaunch.io/plugins/wordpress-cf7-paypal
 * @since             1.0.0
 * @package           Wordpress_CF7_PayPal
 *
 * @wordpress-plugin
 * Plugin Name:       Wordpress CF7 PayPal
 * Plugin URI:        https://welaunch.io/plugins/wordpress-cf7-paypal
 * Description:       Add PayPal to Contact Form 7
 * Version:           1.2.8
 * Author:            weLaunch
 * Author URI:        https://welaunch.io
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       wordpress-cf7-paypal
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-wordpress-cf7-paypal-activator.php
 */
function activate_Wordpress_CF7_PayPal() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-wordpress-cf7-paypal-activator.php';
	$Wordpress_CF7_PayPal_Activator = new Wordpress_CF7_PayPal_Activator();
	$Wordpress_CF7_PayPal_Activator->activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-wordpress-cf7-paypal-deactivator.php
 */
function deactivate_Wordpress_CF7_PayPal() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-wordpress-cf7-paypal-deactivator.php';
	Wordpress_CF7_PayPal_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_Wordpress_CF7_PayPal' );
register_deactivation_hook( __FILE__, 'deactivate_Wordpress_CF7_PayPal' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-wordpress-cf7-paypal.php';

/**
 * Run the Plugin
 * @author Daniel Barenkamp
 * @version 1.0.0
 * @since   1.0.0
 * @link    http://plugins.db-dzine.com
 */
function run_Wordpress_CF7_PayPal() {

	$plugin_data = get_plugin_data( __FILE__ );
	$version = $plugin_data['Version'];

	$plugin = new Wordpress_CF7_PayPal($version);
	$plugin->run();

	return $plugin;

}

include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
if ( (is_plugin_active('redux-framework/redux-framework.php') || is_plugin_active('redux-dev-master/redux-framework.php')) && is_plugin_active('contact-form-7/wp-contact-form-7.php')) {
	$Wordpress_CF7_PayPal = run_Wordpress_CF7_PayPal();
} else {
	add_action( 'admin_notices', 'Wordpress_CF7_PayPal_Not_Installed' );
}

function Wordpress_CF7_PayPal_Not_Installed()
{
	?>
    <div class="error">
      <p><?php _e( 'Wordpress CF7 PayPal requires the free Redux Framework & Contact Form 7 plugin. Please install or activate them before!', 'wordpress-cf7-paypal'); ?></p>
    </div>
    <?php
}
