<?php

    /**
     * For full documentation, please visit: http://docs.reduxframework.com/
     * For a more extensive sample-config file, you may look at:
     * https://github.com/reduxframework/redux-framework/blob/master/sample/sample-config.php
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = "Wordpress_CF7_PayPal_options";

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        'opt_name' => 'Wordpress_CF7_PayPal_options',
        'use_cdn' => TRUE,
        'dev_mode' => FALSE,
        'display_name' => 'WordPress CF7 PayPal',
        'display_version' => '1.2.8',
        'page_title' => 'WordPress CF7 PayPal',
        'update_notice' => TRUE,
        'intro_text' => '',
        'footer_text' => '&copy; '.date('Y').' weLaunch',
        'admin_bar' => TRUE,
        'menu_type' => 'submenu',
        'menu_title' => 'PayPal',
        'allow_sub_menu' => TRUE,
        'page_parent' => 'wpcf7',
        'customizer' => FALSE,
        'default_mark' => '*',
        'hints' => array(
            'icon_position' => 'right',
            'icon_color' => 'lightgray',
            'icon_size' => 'normal',
            'tip_style' => array(
                'color' => 'light',
            ),
            'tip_position' => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect' => array(
                'show' => array(
'duration' => '500',
'event' => 'mouseover',
                ),
                'hide' => array(
'duration' => '500',
'event' => 'mouseleave unfocus',
                ),
            ),
        ),
        'output' => TRUE,
        'output_tag' => TRUE,
        'settings_api' => TRUE,
        'cdn_check_time' => '1440',
        'compiler' => TRUE,
        'page_permissions' => 'manage_options',
        'save_defaults' => TRUE,
        'show_import_export' => TRUE,
        'database' => 'options',
        'transient_time' => '3600',
        'network_sites' => TRUE,
    );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */

    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'help-tab',
            'title'   => __('Information', 'wordpress-cf7-paypal' ),
            'content' => __('<p>Need support? Please use the comment function on codecanyon.</p>', 'wordpress-cf7-paypal' )
        ),
    );
    Redux::setHelpTab( $opt_name, $tabs );

    // Set the help sidebar
    // $content = __('<p>This is the sidebar content, HTML is allowed.</p>', 'wordpress-cf7-paypal' );
    // Redux::setHelpSidebar( $opt_name, $content );


    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    Redux::setSection( $opt_name, array(
        'title'  => __('CF7 PayPal', 'wordpress-cf7-paypal' ),
        'id'     => 'general',
        'desc'   => __('Need support? Please use the comment function on codecanyon.', 'wordpress-cf7-paypal' ),
        'icon'   => 'el el-home',
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __('General', 'wordpress-cf7-paypal' ),
        'id'         => 'general-settings',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'enable',
                'type'     => 'checkbox',
                'title'    => __('Enable', 'wordpress-cf7-paypal' ),
                'subtitle' => __('Enable CF7 PayPal.', 'wordpress-cf7-paypal' ),
                'default'  => '1',
            ),
            array(
                'id'       => 'liveAccount',
                'type'     => 'text',
                'title'    => __( 'Live account', 'wordpress-cf7-paypal' ),
                'subtitle' => __('Put your business Email address here', 'wordpress-cf7-paypal'), 
                'default'  => '',
            ),
            array(
                'id'       => 'sandbox',
                'type'     => 'checkbox',
                'title'    => __('Sandbox Mode', 'wordpress-cf7-paypal' ),
                'subtitle' => __('First you need a Developer account to test the Sandbox Account. Please Visit <a href="https://developer.paypal.com/" target="_blank">developer.paypal.com</a>', 'wordpress-cf7-paypal' ),
                'default'  => '1',
            ),
            array(
                'id'       => 'sandboxAccount',
                'type'     => 'text',
                'title'    => __( 'Sandbox account', 'wordpress-cf7-paypal' ),
                'subtitle' => __('Put your <a href="https://developer.paypal.com/developer/accounts/" target="_blank">sandbox Email address</a> here. Make sure the account type is BUSINESS', 'wordpress-cf7-paypal'), 
                'default'  => '',
            ),
            array(
                'id'       => 'paypalIdentity',
                'type'     => 'text',
                'title'    => __( 'PayPal Identity', 'wordpress-cf7-paypal' ),
                'subtitle' => __('Visit <a href="https://www.sandbox.paypal.com/cgi-bin/customerprofileweb?cmd=%5fprofile%2dwebsite%2dpayments" target="_blank">Website payment options and activate the "Transfer Payment" option.</a>', 'wordpress-cf7-paypal'), 
                'default'  => '',
            ),
            array(
                'id'       => 'api',
                'type'     => 'section',
                'title'    => __( 'API Settings', 'woocommerce-pdf-catalog' ),
                'indent'   => false,
            ),
            array(
                'id'       => 'paypalAPIUser',
                'type'     => 'text',
                'title'    => __( 'PayPal API Username', 'wordpress-cf7-paypal' ),
                'subtitle' => __( 'This will be used for fetching your transactions. You can get your <a href="https://www.sandbox.paypal.com/cgi-bin/webscr?cmd=_profile-api-access">API settings visiting here</a>. A <a href="https://developer.paypal.com/docs/classic/api/apiCredentials/#create-an-api-signature">tutorial from PayPal</a> can be found here.', 'wordpress-cf7-paypal' ),
                'default'  => '',
            ),
            array(
                'id'       => 'paypalAPIPassword',
                'type'     => 'text',
                'title'    => __( 'PayPal API Password', 'wordpress-cf7-paypal' ),
                'default'  => '',
            ),
            array(
                'id'       => 'paypalAPISignature',
                'type'     => 'text',
                'title'    => __( 'PayPal API Signature', 'wordpress-cf7-paypal' ),
                'default'  => '',
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __('Payment options', 'wordpress-cf7-paypal' ),
        'id'         => 'payment',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'sendMail',
                'type'     => 'select',
                'title'    => __('Send Mail', 'wordpress-cf7-paypal' ),
                'subtitle' => __('Check this if you want to send the normal CF7 mail even when the paypment was cancelled or successfull.', 'wordpress-cf7-paypal' ),
                'options'  => array(
                    'never' => 'Never',
                    'success' => __('Payment Successfull', 'wordpress-cf7-paypal'),
                    'always' => __('Always', 'wordpress-cf7-paypal'),
                ) 
            ),
            array(
                'id'       => 'landingPage',
                'type'     => 'select',
                'title'    => __('Landing Page', 'wordpress-cf7-paypal' ),
                'subtitle' => __('Choose Login Page or Billing page where the user should land when he wants to do a payment.', 'wordpress-cf7-paypal' ),
                'options'  => array(
                    'login' => __('Login', 'wordpress-cf7-paypal'),
                    'billing' => __('Billing', 'wordpress-cf7-paypal'),
                ),
                'default' => 'login'
            ),
            array(
                'id'       => 'country',
                'type'     => 'select',
                'title'    => __( 'Country', 'wordpress-cf7-paypal' ),
                'subtitle' => __('See: <a href="https://developer.paypal.com/docs/classic/api/country_codes/" target="_blank">PayPal Country Code Reference</a>', 'wordpress-cf7-paypal' ),
                'options'  => array(
                    'AL' => __('Albania', 'wordpress-cf7-paypal' ),'DZ' => __('Algeria', 'wordpress-cf7-paypal' ),'AD' => __('Andorra', 'wordpress-cf7-paypal' ),'AO' => __('Angola', 'wordpress-cf7-paypal' ),'AI' => __('Anguilla', 'wordpress-cf7-paypal' ),'AG' => __('Antigua & Barbuda', 'wordpress-cf7-paypal' ),'AR' => __('Argentina', 'wordpress-cf7-paypal' ),'AM' => __('Armenia', 'wordpress-cf7-paypal' ),'AW' => __('Aruba', 'wordpress-cf7-paypal' ),'AU' => __('Australia', 'wordpress-cf7-paypal' ),'AT' => __('Austria', 'wordpress-cf7-paypal' ),'AZ' => __('Azerbaijan', 'wordpress-cf7-paypal' ),'BS' => __('Bahamas', 'wordpress-cf7-paypal' ),'BH' => __('Bahrain', 'wordpress-cf7-paypal' ),'BB' => __('Barbados', 'wordpress-cf7-paypal' ),'BY' => __('Belarus', 'wordpress-cf7-paypal' ),'BE' => __('Belgium', 'wordpress-cf7-paypal' ),'BZ' => __('Belize', 'wordpress-cf7-paypal' ),'BJ' => __('Benin', 'wordpress-cf7-paypal' ),'BM' => __('Bermuda', 'wordpress-cf7-paypal' ),'BT' => __('Bhutan', 'wordpress-cf7-paypal' ),'BO' => __('Bolivia', 'wordpress-cf7-paypal' ),'BA' => __('Bosnia & Herzegovina', 'wordpress-cf7-paypal' ),'BW' => __('Botswana', 'wordpress-cf7-paypal' ),'BR' => __('Brazil', 'wordpress-cf7-paypal' ),'VG' => __('British Virgin Islands', 'wordpress-cf7-paypal' ),'BN' => __('Brunei', 'wordpress-cf7-paypal' ),'BG' => __('Bulgaria', 'wordpress-cf7-paypal' ),'BF' => __('Burkina Faso', 'wordpress-cf7-paypal' ),'BI' => __('Burundi', 'wordpress-cf7-paypal' ),'KH' => __('Cambodia', 'wordpress-cf7-paypal' ),'CM' => __('Cameroon', 'wordpress-cf7-paypal' ),'CA' => __('Canada', 'wordpress-cf7-paypal' ),'CV' => __('Cape Verde', 'wordpress-cf7-paypal' ),'KY' => __('Cayman Islands', 'wordpress-cf7-paypal' ),'TD' => __('Chad', 'wordpress-cf7-paypal' ),'CL' => __('Chile', 'wordpress-cf7-paypal' ),'CN' => __('China    (For domestic Chinese bank transactions only', 'wordpress-cf7-paypal' ),'C2' => __('China Worldwide  (For CUP, bank card and cross-border transactions', 'wordpress-cf7-paypal' ),'CO' => __('Colombia', 'wordpress-cf7-paypal' ),'KM' => __('Comoros', 'wordpress-cf7-paypal' ),'CG' => __('Congo - Brazzaville', 'wordpress-cf7-paypal' ),'CD' => __('Congo - Kinshasa', 'wordpress-cf7-paypal' ),'CK' => __('Cook Islands', 'wordpress-cf7-paypal' ),'CR' => __('Costa Rica', 'wordpress-cf7-paypal' ),'CI' => __('Côte D’ivoire', 'wordpress-cf7-paypal' ),'HR' => __('Croatia', 'wordpress-cf7-paypal' ),'CY' => __('Cyprus', 'wordpress-cf7-paypal' ),'CZ' => __('Czech Republic', 'wordpress-cf7-paypal' ),'DK' => __('Denmark', 'wordpress-cf7-paypal' ),'DJ' => __('Djibouti', 'wordpress-cf7-paypal' ),'DM' => __('Dominica', 'wordpress-cf7-paypal' ),'DO' => __('Dominican Republic', 'wordpress-cf7-paypal' ),'EC' => __('Ecuador', 'wordpress-cf7-paypal' ),'EG' => __('Egypt', 'wordpress-cf7-paypal' ),'SV' => __('El Salvador', 'wordpress-cf7-paypal' ),'ER' => __('Eritrea', 'wordpress-cf7-paypal' ),'EE' => __('Estonia', 'wordpress-cf7-paypal' ),'ET' => __('Ethiopia', 'wordpress-cf7-paypal' ),'FK' => __('Falkland Islands', 'wordpress-cf7-paypal' ),'FO' => __('Faroe Islands', 'wordpress-cf7-paypal' ),'FJ' => __('Fiji', 'wordpress-cf7-paypal' ),'FI' => __('Finland', 'wordpress-cf7-paypal' ),'FR' => __('France', 'wordpress-cf7-paypal' ),'GF' => __('French Guiana', 'wordpress-cf7-paypal' ),'PF' => __('French Polynesia', 'wordpress-cf7-paypal' ),'GA' => __('Gabon', 'wordpress-cf7-paypal' ),'GM' => __('Gambia', 'wordpress-cf7-paypal' ),'GE' => __('Georgia', 'wordpress-cf7-paypal' ),'DE' => __('Germany', 'wordpress-cf7-paypal' ),'GI' => __('Gibraltar', 'wordpress-cf7-paypal' ),'GR' => __('Greece', 'wordpress-cf7-paypal' ),'GL' => __('Greenland', 'wordpress-cf7-paypal' ),'GD' => __('Grenada', 'wordpress-cf7-paypal' ),'GP' => __('Guadeloupe', 'wordpress-cf7-paypal' ),'GT' => __('Guatemala', 'wordpress-cf7-paypal' ),'GN' => __('Guinea', 'wordpress-cf7-paypal' ),'GW' => __('Guinea-bissau', 'wordpress-cf7-paypal' ),'GY' => __('Guyana', 'wordpress-cf7-paypal' ),'HN' => __('Honduras', 'wordpress-cf7-paypal' ),'HK' => __('Hong Kong Sar China', 'wordpress-cf7-paypal' ),'HU' => __('Hungary', 'wordpress-cf7-paypal' ),'IS' => __('Iceland', 'wordpress-cf7-paypal' ),'IN' => __('India', 'wordpress-cf7-paypal' ),'ID' => __('Indonesia', 'wordpress-cf7-paypal' ),'IE' => __('Ireland', 'wordpress-cf7-paypal' ),'IL' => __('Israel', 'wordpress-cf7-paypal' ),'IT' => __('Italy', 'wordpress-cf7-paypal' ),'JM' => __('Jamaica', 'wordpress-cf7-paypal' ),'JP' => __('Japan', 'wordpress-cf7-paypal' ),'JO' => __('Jordan', 'wordpress-cf7-paypal' ),'KZ' => __('Kazakhstan', 'wordpress-cf7-paypal' ),'KE' => __('Kenya', 'wordpress-cf7-paypal' ),'KI' => __('Kiribati', 'wordpress-cf7-paypal' ),'KW' => __('Kuwait', 'wordpress-cf7-paypal' ),'KG' => __('Kyrgyzstan', 'wordpress-cf7-paypal' ),'LA' => __('Laos', 'wordpress-cf7-paypal' ),'LV' => __('Latvia', 'wordpress-cf7-paypal' ),'LS' => __('Lesotho', 'wordpress-cf7-paypal' ),'LI' => __('Liechtenstein', 'wordpress-cf7-paypal' ),'LT' => __('Lithuania', 'wordpress-cf7-paypal' ),'LU' => __('Luxembourg', 'wordpress-cf7-paypal' ),'MK' => __('Macedonia', 'wordpress-cf7-paypal' ),'MG' => __('Madagascar', 'wordpress-cf7-paypal' ),'MW' => __('Malawi', 'wordpress-cf7-paypal' ),'MY' => __('Malaysia', 'wordpress-cf7-paypal' ),'MV' => __('Maldives', 'wordpress-cf7-paypal' ),'ML' => __('Mali', 'wordpress-cf7-paypal' ),'MT' => __('Malta', 'wordpress-cf7-paypal' ),'MH' => __('Marshall Islands', 'wordpress-cf7-paypal' ),'MQ' => __('Martinique', 'wordpress-cf7-paypal' ),'MR' => __('Mauritania', 'wordpress-cf7-paypal' ),'MU' => __('Mauritius', 'wordpress-cf7-paypal' ),'YT' => __('Mayotte', 'wordpress-cf7-paypal' ),'MX' => __('Mexico', 'wordpress-cf7-paypal' ),'FM' => __('Micronesia', 'wordpress-cf7-paypal' ),'MD' => __('Moldova', 'wordpress-cf7-paypal' ),'MC' => __('Monaco', 'wordpress-cf7-paypal' ),'MN' => __('Mongolia', 'wordpress-cf7-paypal' ),'ME' => __('Montenegro', 'wordpress-cf7-paypal' ),'MS' => __('Montserrat', 'wordpress-cf7-paypal' ),'MA' => __('Morocco', 'wordpress-cf7-paypal' ),'MZ' => __('Mozambique', 'wordpress-cf7-paypal' ),'NA' => __('Namibia', 'wordpress-cf7-paypal' ),'NR' => __('Nauru', 'wordpress-cf7-paypal' ),'NP' => __('Nepal', 'wordpress-cf7-paypal' ),'NL' => __('Netherlands', 'wordpress-cf7-paypal' ),'NC' => __('New Caledonia', 'wordpress-cf7-paypal' ),'NZ' => __('New Zealand', 'wordpress-cf7-paypal' ),'NI' => __('Nicaragua', 'wordpress-cf7-paypal' ),'NE' => __('Niger', 'wordpress-cf7-paypal' ),'NG' => __('Nigeria', 'wordpress-cf7-paypal' ),'NU' => __('Niue', 'wordpress-cf7-paypal' ),'NF' => __('Norfolk Island', 'wordpress-cf7-paypal' ),'NO' => __('Norway', 'wordpress-cf7-paypal' ),'OM' => __('Oman', 'wordpress-cf7-paypal' ),'PW' => __('Palau', 'wordpress-cf7-paypal' ),'PA' => __('Panama', 'wordpress-cf7-paypal' ),'PG' => __('Papua New Guinea', 'wordpress-cf7-paypal' ),'PY' => __('Paraguay', 'wordpress-cf7-paypal' ),'PE' => __('Peru', 'wordpress-cf7-paypal' ),'PH' => __('Philippines', 'wordpress-cf7-paypal' ),'PN' => __('Pitcairn Islands', 'wordpress-cf7-paypal' ),'PL' => __('Poland', 'wordpress-cf7-paypal' ),'PT' => __('Portugal', 'wordpress-cf7-paypal' ),'QA' => __('Qatar', 'wordpress-cf7-paypal' ),'RE' => __('Réunion', 'wordpress-cf7-paypal' ),'RO' => __('Romania', 'wordpress-cf7-paypal' ),'RU' => __('Russia', 'wordpress-cf7-paypal' ),'RW' => __('Rwanda', 'wordpress-cf7-paypal' ),'WS' => __('Samoa', 'wordpress-cf7-paypal' ),'SM' => __('San Marino', 'wordpress-cf7-paypal' ),'ST' => __('São Tomé & Príncipe', 'wordpress-cf7-paypal' ),'SA' => __('Saudi Arabia', 'wordpress-cf7-paypal' ),'SN' => __('Senegal', 'wordpress-cf7-paypal' ),'RS' => __('Serbia', 'wordpress-cf7-paypal' ),'SC' => __('Seychelles', 'wordpress-cf7-paypal' ),'SL' => __('Sierra Leone', 'wordpress-cf7-paypal' ),'SG' => __('Singapore', 'wordpress-cf7-paypal' ),'SK' => __('Slovakia', 'wordpress-cf7-paypal' ),'SI' => __('Slovenia', 'wordpress-cf7-paypal' ),'SB' => __('Solomon Islands', 'wordpress-cf7-paypal' ),'SO' => __('Somalia', 'wordpress-cf7-paypal' ),'ZA' => __('South Africa', 'wordpress-cf7-paypal' ),'KR' => __('South Korea', 'wordpress-cf7-paypal' ),'ES' => __('Spain', 'wordpress-cf7-paypal' ),'LK' => __('Sri Lanka', 'wordpress-cf7-paypal' ),'SH' => __('St. Helena', 'wordpress-cf7-paypal' ),'KN' => __('St. Kitts & Nevis', 'wordpress-cf7-paypal' ),'LC' => __('St. Lucia', 'wordpress-cf7-paypal' ),'PM' => __('St. Pierre & Miquelon', 'wordpress-cf7-paypal' ),'VC' => __('St. Vincent & Grenadines', 'wordpress-cf7-paypal' ),'SR' => __('Suriname', 'wordpress-cf7-paypal' ),'SJ' => __('Svalbard & Jan Mayen', 'wordpress-cf7-paypal' ),'SZ' => __('Swaziland', 'wordpress-cf7-paypal' ),'SE' => __('Sweden', 'wordpress-cf7-paypal' ),'CH' => __('Switzerland', 'wordpress-cf7-paypal' ),'TW' => __('Taiwan', 'wordpress-cf7-paypal' ),'TJ' => __('Tajikistan', 'wordpress-cf7-paypal' ),'TZ' => __('Tanzania', 'wordpress-cf7-paypal' ),'TH' => __('Thailand', 'wordpress-cf7-paypal' ),'TG' => __('Togo', 'wordpress-cf7-paypal' ),'TO' => __('Tonga', 'wordpress-cf7-paypal' ),'TT' => __('Trinidad & Tobago', 'wordpress-cf7-paypal' ),'TN' => __('Tunisia', 'wordpress-cf7-paypal' ),'TM' => __('Turkmenistan', 'wordpress-cf7-paypal' ),'TC' => __('Turks & Caicos Islands', 'wordpress-cf7-paypal' ),'TV' => __('Tuvalu', 'wordpress-cf7-paypal' ),'UG' => __('Uganda', 'wordpress-cf7-paypal' ),'UA' => __('Ukraine', 'wordpress-cf7-paypal' ),'AE' => __('United Arab Emirates', 'wordpress-cf7-paypal' ),'GB' => __('United Kingdom', 'wordpress-cf7-paypal' ),'US' => __('United States', 'wordpress-cf7-paypal' ),'UY' => __('Uruguay', 'wordpress-cf7-paypal' ),'VU' => __('Vanuatu', 'wordpress-cf7-paypal' ),'VA' => __('Vatican City', 'wordpress-cf7-paypal' ),'VE' => __('Venezuela', 'wordpress-cf7-paypal' ),'VN' => __('Vietnam', 'wordpress-cf7-paypal' ),'WF' => __('Wallis & Futuna', 'wordpress-cf7-paypal' ),'YE' => __('Yemen', 'wordpress-cf7-paypal' ),'ZM' => __('Zambia', 'wordpress-cf7-paypal' ),'ZW' => __('Zimbabwe', 'wordpress-cf7-paypal' ),                
                ),
            ),
            array(
                'id'       => 'currency',
                'type'     => 'select',
                'title'    => __( 'Currency', 'wordpress-cf7-paypal' ),
                'subtitle' => __('See: <a href="https://developer.paypal.com/docs/classic/api/currency_codes/" target="_blank">PayPal Currency Reference</a>', 'wordpress-cf7-paypal' ),
                'options'  => array(
                    'AUD' => __('Australian Dollar (AUD)', 'wordpress-cf7-paypal'),
                    'BRL' => __('Brazilian Real (BRL)', 'wordpress-cf7-paypal'),
                    'CAD' => __('Canadian Dollar (CAD)', 'wordpress-cf7-paypal'),
                    'CZK' => __('Czech Koruna (CZK)', 'wordpress-cf7-paypal'),
                    'DKK' => __('Danish Krone (DKK)', 'wordpress-cf7-paypal'),
                    'EUR' => __('Euro (EUR)', 'wordpress-cf7-paypal'),
                    'HKD' => __('Hong Kong Dollar (HKD)', 'wordpress-cf7-paypal'),
                    'HUF' => __('Hungarian Forint (HUF)', 'wordpress-cf7-paypal'),
                    'ILS' => __('Israeli New Sheqel (ILS)', 'wordpress-cf7-paypal'),
                    'JPY' => __('Japanese Yen (JPY)', 'wordpress-cf7-paypal'),
                    'MYR' => __('Malaysian Ringgit (MYR)', 'wordpress-cf7-paypal'),
                    'MXN' => __('Mexican Peso (MXN)', 'wordpress-cf7-paypal'),
                    'NOK' => __('Norwegian Krone (NOK)', 'wordpress-cf7-paypal'),
                    'NZD' => __('New Zealand Dollar (NZD)', 'wordpress-cf7-paypal'),
                    'PHP' => __('Philippine Peso (PHP)', 'wordpress-cf7-paypal'),
                    'PLN' => __('Polish Zloty (PLN)', 'wordpress-cf7-paypal'),
                    'GBP' => __('Pound Sterling (GBP)', 'wordpress-cf7-paypal'),
                    'R' => __('Russian Ruble (R)', 'wordpress-cf7-paypal'),
                    'SGD' => __('Singapore Dollar (SGD)', 'wordpress-cf7-paypal'),
                    'SEK' => __('Swedish Krona (SEK)', 'wordpress-cf7-paypal'),
                    'CHF' => __('Swiss Franc (CHF)', 'wordpress-cf7-paypal'),
                    'TWD' => __('Taiwan New Dollar (TWD)', 'wordpress-cf7-paypal'),
                    'THB' => __('Thai Baht (THB)', 'wordpress-cf7-paypal'),
                    'USD' => __('U.S. Dollar (USD)', 'wordpress-cf7-paypal'),
                ),
                'default' => 'USD',
            ),
            array(
                'id'       => 'locale',
                'type'     => 'select',
                'title'    => __( 'Locale', 'wordpress-cf7-paypal' ),
                'subtitle' => __('See: <a href="https://developer.paypal.com/docs/classic/api/country_codes/" target="_blank">PayPal Locales Code Reference</a>', 'wordpress-cf7-paypal' ),
                'options'  => array(
                    'ar_EG' => 'ar_EG (Algeria, Bahrain, Egypt, Jordan, Kuwait, Morocco, Oman, Qatar, Saudi Arabia, Tunisia, United Arab Emirates, Yemen)',
                    'en_AU' => __('en_AU (Australia)', 'wordpress-cf7-paypal'),
                    'de_DE' => __('de_DE (Austria, Germany, Luxembourg, Switzerland)', 'wordpress-cf7-paypal'),
                    'fr_FR' => __('fr_FR (Belgium, France, Switzerland)', 'wordpress-cf7-paypal'),
                    'nl_NL' => __('nl_NL (Belgium, Netherlands)', 'wordpress-cf7-paypal'),
                    'pt_BR' => __('pt_BR (Brazil)', 'wordpress-cf7-paypal'),
                    'fr_CA' => __('fr_CA (Canada)', 'wordpress-cf7-paypal'),
                    'zh_CN' => __('zh_CN (China)', 'wordpress-cf7-paypal'),
                    'da_DK' => __('da_DK (Denmark, Faroe ISLANDS, Greenland)', 'wordpress-cf7-paypal'),
                    'ru_RU' => __('ru_RU (Estonia, Latvia, Lithuania, Russia, Ukraine)', 'wordpress-cf7-paypal'),
                    'zh_HK' => __('zh_HK (Hong Kong SAR China)', 'wordpress-cf7-paypal'),
                    'id_ID' => __('id_ID (Indonesia ', 'wordpress-cf7-paypal'),
                    'he_IL' => __('he_IL (Israel)', 'wordpress-cf7-paypal'),
                    'it_IT' => __('it_IT (Italy)', 'wordpress-cf7-paypal'),
                    'ja_JP' => __('ja_JP (Japan)', 'wordpress-cf7-paypal'),
                    'no_NO' => __('no_NO (Norway)', 'wordpress-cf7-paypal'),
                    'pl_PL' => __('pl_PL (Poland)', 'wordpress-cf7-paypal'),
                    'pt_PT' => __('pt_PT (Portugal)', 'wordpress-cf7-paypal'),
                    'ko_KR' => __('ko_KR (South KOREA)', 'wordpress-cf7-paypal'),
                    'es_ES' => __('es_ES (Spain)', 'wordpress-cf7-paypal'),
                    'sv_SE' => __('sv_SE (Sweden)', 'wordpress-cf7-paypal'),
                    'zh_TW' => __('zh_TW (Taiwan)', 'wordpress-cf7-paypal'),
                    'th_TH' => __('th_TH (Thailand)', 'wordpress-cf7-paypal'),
                    'en_GB' => __('en_GB (United Kingdom, India, Singapore)', 'wordpress-cf7-paypal'),
                    'en_US' => __('en_US (United States)', 'wordpress-cf7-paypal'),
                    
                ),
                'default' => 'en_US',
            ),
            array(
                'id'       => 'taxFixed',
                'type'     => 'text',
                'title'    => __( 'Fixed Tax', 'wordpress-cf7-paypal' ),
                'subtitle' => __( 'Set a fixed Tax amount (e.g. 0.50 for 50 cents). Note: This value overrides any tax settings set in your account profile.', 'wordpress-cf7-paypal'), 
                'default'  => '',
            ),
            array(
                'id'       => 'taxRate',
                'type'     => 'text',
                'title'    => __( 'Tax Rate', 'wordpress-cf7-paypal' ),
                'subtitle' => __( 'Enter your tax rate in percentage without % (e.g. 19). Note: This value overrides any tax settings set in your account profile. ', 'wordpress-cf7-paypal'), 
                'default'  => '',
            ),
            array(
                'id'       => 'returnURL',
                'type'     => 'text',
                'title'    => __( 'Return URL', 'wordpress-cf7-paypal' ),
                'subtitle' => __( 'Redirect URL when paypement was successfull. Note: you have to enable the redirect inside your paypal Business account settings. 
                                    <a href="http://stackoverflow.com/questions/7642895/setting-paypal-return-url-and-making-it-auto-return" target="_blank">Please see Instructions here.</a>', 'wordpress-cf7-paypal'), 
                'default'  => '',
            ),
            array(
                'id'       => 'cancelURL',
                'type'     => 'text',
                'title'    => __( 'Cancel URL', 'wordpress-cf7-paypal' ),
                'subtitle' => __( 'Redirect URL when paypement was canceled. Note: you have to enable the redirect inside your paypal Business account settings. 
                                    <a href="http://stackoverflow.com/questions/7642895/setting-paypal-return-url-and-making-it-auto-return" target="_blank">Please see Instructions here.</a>', 'wordpress-cf7-paypal'), 
                'default'  => '',
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __('Advanced settings', 'wordpress-cf7-paypal' ),
        'desc'       => __('Custom stylesheet / javascript.', 'wordpress-cf7-paypal' ),
        'id'         => 'advanced',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'customCSS',
                'type'     => 'ace_editor',
                'mode'     => 'css',
                'title'    => __('Custom CSS', 'wordpress-cf7-paypal' ),
                'subtitle' => __('Add some stylesheet if you want.', 'wordpress-cf7-paypal' ),
            ),
            array(
                'id'       => 'customJS',
                'type'     => 'ace_editor',
                'mode'     => 'javascript',
                'title'    => __('Custom JS', 'wordpress-cf7-paypal' ),
                'subtitle' => __('Add some javascript if you want.', 'wordpress-cf7-paypal' ),
            ),           
        )
    ));


    /*
     * <--- END SECTIONS
     */
