<?php

/**
 * Fired during plugin activation
 *
 * @link       http://woocommerce.db-dzine.de
 * @since      1.0.0
 *
 * @package    Wordpress_CF7_PayPal
 * @subpackage Wordpress_CF7_PayPal/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Wordpress_CF7_PayPal
 * @subpackage Wordpress_CF7_PayPal/includes
 * @author     Daniel Barenkamp <contact@db-dzine.de>
 */
class Wordpress_CF7_PayPal_Activator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public function activate() {

		global $wpdb;

		if ( is_multisite() ) {

			$blog_ids = $wpdb->get_col( "SELECT blog_id FROM $wpdb->blogs" );
			foreach ( $blog_ids as $blog_id ) {
			    switch_to_blog( $blog_id );
			    $this->create_table();
			    restore_current_blog();
			}
		} else {
			$this->create_table();
		}
	}

	public function delete_table()
	{
		global $wpdb;

		$db_name = $wpdb->prefix . 'cf7_paypal';

		$wpdb->query( "DROP TABLE IF EXISTS " . $db_name );
	}

	public function create_table() {

	   	global $wpdb;

	   	$db_name = $wpdb->prefix . 'cf7_paypal';
	 
		// create the ECPT metabox database table
		if($wpdb->get_var("show tables like '$db_name'") != $db_name) 
		{
			$sql = "CREATE TABLE " . $db_name . " (
				`id` mediumint(9) NOT NULL AUTO_INCREMENT,
				`cf7_paypal_unique` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
				`flamingo_id` varchar(255) COLLATE utf8_unicode_ci NULL,
				`item_number` varchar(255) COLLATE utf8_unicode_ci NULL,
				`txn_id` varchar(255) COLLATE utf8_unicode_ci NULL,
				`payment_gross` float(10,2) NULL,
				`currency_code` varchar(5) COLLATE utf8_unicode_ci NULL,
				`payment_status` varchar(255) COLLATE utf8_unicode_ci NULL,
				`form_data` varchar(5000) COLLATE utf8_unicode_ci NULL,
				UNIQUE KEY id (id),
				UNIQUE KEY cf7_paypal_unique (cf7_paypal_unique),
				UNIQUE KEY txn_id (txn_id)
			);";
	 
			require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
			dbDelta($sql);
		}
	}

}
