<?php

class Wordpress_CF7_PayPal_Public
{
    private $plugin_name;
    private $version;
    private $options;
    private $cf7_paypal_unique;

    /**
     * CF7 PayPal Plugin Construct
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @param   string                         $plugin_name 
     * @param   string                         $version    
     */
    public function __construct($plugin_name, $version)
    {
        $this->plugin_name = $plugin_name;
        $this->version = $version;
    }

    /**
     * Enqueue Styles
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  boolean
     */
    public function enqueue_styles()
    {
        global $Wordpress_CF7_PayPal_options;

        $this->options = $Wordpress_CF7_PayPal_options;

        if (!$this->get_option('enable')) {
            return false;
        }

        $customCSS = $this->get_option('customCSS');

        if(empty($customCSS)) {
            return false;
        }

        file_put_contents(dirname(__FILE__)  . '/css/wordpress-cf7-paypal-custom.css', $customCSS);
        wp_enqueue_style($this->plugin_name.'-custom', plugin_dir_url(__FILE__).'css/wordpress-cf7-paypal-custom.css', array(), $this->version, 'all');

        return true;
    }

    /**
     * Register the JavaScript for the public-facing side of the site.
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  boolean
     */
    public function enqueue_scripts()
    {
        global $Wordpress_CF7_PayPal_options;

        $this->options = $Wordpress_CF7_PayPal_options;

        if (!$this->get_option('enable')) {
            return false;
        }

        wp_enqueue_script($this->plugin_name.'-public', plugin_dir_url(__FILE__).'js/wordpress-cf7-paypal-public.js', array('jquery', 'contact-form-7'), $this->version, true);

        $forJS = array(
            'redirectingText' => __( 'Redirecting you to PayPal', 'wordpress-cf7-paypal' ),
        );

        wp_localize_script($this->plugin_name.'-public', 'cf7_paypal_options', $forJS);

        $customJS = $this->get_option('customJS');
        if (empty($customJS)) {
            return false;
        }

        file_put_contents(dirname(__FILE__)  . '/js/wordpress-cf7-paypal-custom.js', $customJS);

        wp_enqueue_script($this->plugin_name.'-custom', plugin_dir_url(__FILE__).'js/wordpress-cf7-paypal-custom.js', array('jquery'), $this->version, false);

        return true;
    }

    /**
     * Get Options
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @param   mixed                         $option The option key
     * @return  mixed                                 The option value
     */
    private function get_option($option)
    {
        if (!is_array($this->options)) {
            return false;
        }

        if (!array_key_exists($option, $this->options)) {
            return false;
        }

        return $this->options[$option];
    }

    /**
     * Init the CF7 PayPal
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  boolean
     */
    public function init()
    {
        global $Wordpress_CF7_PayPal_options;

        $this->options = $Wordpress_CF7_PayPal_options;

        if (!$this->get_option('enable')) {
            return false;
        }

        if(isset($_GET['cf7_paypal_sucess']) && !empty($_GET['cf7_paypal_sucess'])) {
        	$this->payment_successfull();
        }

        if(isset($_GET['cf7_paypal_cancelled']) && !empty($_GET['cf7_paypal_cancelled'])) {
            $this->payment_cancelled();
        }

    }

    /**
     * Add the PayPal Shortcode
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  mixed                                 The option value
     */
    public function wpcf7_add_shortcode_submit()
    {
        if (version_compare(WPCF7_VERSION, '4.6') >= 0) {
             wpcf7_add_form_tag('paypal', array($this, 'wpcf7_paypal_shortcode_handler' ));
        } else {
            wpcf7_add_shortcode('paypal', array($this, 'wpcf7_paypal_shortcode_handler' ));
        }
       
    }
     
    /**
     * Add the PayPal Shortcode Handler
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  string
     */
    public function wpcf7_paypal_shortcode_handler($tag)
    {

        if (version_compare(WPCF7_VERSION, '4.6') >= 0) {
            $tag = new WPCF7_FormTag( $tag );
        } else {
            $tag = new WPCF7_Shortcode( $tag );
        }

        $this->cf7_paypal_unique = uniqid();
		$class = wpcf7_form_controls_class( $tag->type );

		$customReturnURL = $tag->get_option('return');
		if(isset($customReturnURL) && !empty($customReturnURL[0]) ) {
			$customReturnURL = $customReturnURL[0];
		} else {
			$customReturnURL = FALSE;
		}

		$customCancelReturnURL = $tag->get_option('cancel_return');
		if(isset($customCancelReturnURL) && !empty($customCancelReturnURL[0]) ) {
			$customCancelReturnURL = $customCancelReturnURL[0];
		} else {
			$customCancelReturnURL = FALSE;
		}

		$atts = array();

		$atts['class'] = $tag->get_class_option( $class );
		$atts['id'] = 'paypal-submit';
		$atts['tabindex'] = $tag->get_option( 'tabindex', 'int', true );

		$value = isset( $tag->values[0] ) ? $tag->values[0] : '';

		if ( empty( $value ) )
			$value = __( 'Send', 'contact-form-7' );

		$atts['type'] = 'submit';
		$atts['value'] = $value;

		$atts = wpcf7_format_atts( $atts );

		$html = '
            <input type="hidden" name="paypal_clicked" value="no">
            <input type="hidden" name="cf7_paypal_unique" value="' . $this->cf7_paypal_unique . '">
            <input type="hidden" name="paypal_url" value="' . $this->get_paypal_url() . '">

            <input type="hidden" name="landing_page" value="' . $this->get_landing_page() . '" />

            <input type="hidden" name="cmd" value="_cart">
            <input type="hidden" name="charset" value="utf-8">

            <input type="hidden" name="upload" value="1">

            <input type="hidden" name="business" value="' . $this->get_account() . '">
            <input type="hidden" name="lc" value="' . $this->get_locale() . '">

            <input type="hidden" name="currency_code" value="' . $this->get_currency() . '" />

            <input type="hidden" name="return" value="' . $this->get_return_url($customReturnURL) . '">
            <input type="hidden" name="cancel_return" value="' . $this->get_cancel_url($customCancelReturnURL) . '" />';

        $html .= $this->maybe_add_fixed_tax($html);
        $html .= $this->maybe_add_tax_rate($html);

		$html .= sprintf( '<input %1$s />', $atts );

		return $html;
    }

    /**
     * Get the PayPal URL
     * 
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  string
     */
    private function get_paypal_url()
    {
    	$paypal_url = "https://www.sandbox.paypal.com/cgi-bin/webscr";

        $sandbox = $this->get_option('sandbox');
    	if($sandbox === "0") {
    		$paypal_url = "https://www.paypal.com/cgi-bin/webscr";
    	}
    	
    	return $paypal_url;
    }

    /**
     * Get the PayPal Business Account
     * 
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  string
     */
    private function get_account()
    {
    	$paypal_account = "";

        $sandbox = $this->get_option('sandbox');
        $sandboxAccount = $this->get_option('sandboxAccount');
        $liveAccount = $this->get_option('liveAccount');
    	if($sandbox === "1" && !empty($sandboxAccount) ) {
    		$paypal_account = $this->get_option('sandboxAccount');
    	}

    	if($sandbox === "0" && !empty($liveAccount) ) {
    		$paypal_account = $liveAccount;
    	}
    	
    	return $paypal_account;
    }

    /**
     * Get the PayPal Landingpage Type
     * 
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.2.6
     * @link    http://plugins.db-dzine.com
     * @return  string
     */
    private function get_landing_page()
    {
        $landingPage = "login";

        $checkLandingPage = $this->get_option('landingPage');
        if( !empty($checkLandingPage) ) {
            $landingPage = $checkLandingPage;
        }
        
        return $landingPage;
    }

    /**
     * Get the Locale
     * 
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  string
     */
    private function get_locale()
    {
    	$locale = "en_US";

        $checkLocale = $this->get_option('locale');
    	if( !empty($checkLocale) ) {
    		$locale = $checkLocale;
    	}
    	
    	return $locale;
    }

    /**
     * Get the Currency
     * 
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  string
     */
    private function get_currency()
    {
    	$currency = "USD";

        $checkCurrency = $this->get_option('currency');
    	if( !empty($checkCurrency) ) {
    		$currency = $checkCurrency;
    	}
    	
    	return $currency;
    }

    /**
     * Get the return URL
     * 
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  string
     */
    private function get_return_url($customReturnURL)
    {
    	$returnURL = esc_url(get_permalink());

        $checkReturnURL = $this->get_option('returnURL');
    	if( !empty($checkReturnURL) ) {
    		$returnURL = $checkReturnURL;
    	}
    	if(!empty($customReturnURL)) {
    		$returnURL = $customReturnURL;
    	}

        $query = parse_url($returnURL, PHP_URL_QUERY);
        if ($query) {
            $returnURL .= '&cf7_paypal_unique=' . $this->cf7_paypal_unique . '&cf7_paypal_sucess=yes';
        } else {
            $returnURL .= '?cf7_paypal_unique=' . $this->cf7_paypal_unique . '&cf7_paypal_sucess=yes';
        }

    	return $returnURL;
    }

    /**
     * Get the cancel URL
     * 
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  string
     */
    private function get_cancel_url($customCancelReturnURL)
    {
    	$cancelURL = esc_url(get_permalink());

        $checkCustomURL = $this->get_option('cancelURL');
    	if( !empty($checkCustomURL) ) {
    		$cancelURL = $checkCustomURL;
    	}

    	if(!empty($customCancelReturnURL)) {
    		$cancelURL = $customCancelReturnURL;
    	}
    	
        $query = parse_url($cancelURL, PHP_URL_QUERY);
        if ($query) {
            $cancelURL .= '&cf7_paypal_unique=' . $this->cf7_paypal_unique . '&cf7_paypal_cancelled=yes';
        } else {
            $cancelURL .= '?cf7_paypal_unique=' . $this->cf7_paypal_unique . '&cf7_paypal_cancelled=yes';
        }

    	return $cancelURL;
    }

    /**
     * Maybe add the Fixed Tax
     * 
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  string
     */
    private function maybe_add_fixed_tax()
    {
    	$html = "";

    	$fixedTax = $this->get_option('taxFixed');
    	if( !empty($fixedTax) ) {
    		$html .= '<input type="hidden" name="tax" value="' . $fixedTax . '">';
    	}
    	
    	return $html;
    }

    /**
     * Maybe add the Tax Rate
     * 
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  string
     */
    private function maybe_add_tax_rate()
    {
    	$html = "";

    	$taxRate = $this->get_option('taxRate');
    	if( !empty($taxRate) ) {
    		$html .= '<input type="hidden" name="tax_rate" value="' . $taxRate . '">';
    	}
    	
    	return $html;
    }

    /**
     * Store paypal Return parameters in Database
     * ?tx=XXXXX&st=Pending&amt=10%2e00&cc=USD&cm=&item_number=
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  bool
     */
    public function payment_successfull()
    {
    	global $wpdb, $_POST;

        $sendMail = $this->get_option('sendMail');

        $item_number = isset($_GET['item_number']) ? $_GET['item_number'] : '';
        $txn_id = isset($_GET['tx']) ? $_GET['tx'] : '';
        $payment_gross = isset($_GET['amt']) ? $_GET['amt'] : '';
        $currency_code = isset($_GET['cc']) ? $_GET['cc'] : '';
        $payment_status = isset($_GET['st']) ? $_GET['st'] : '';

        $cf7_paypal_unique = $_GET['cf7_paypal_unique'];

        if(empty($txn_id) || empty($cf7_paypal_unique)) {
            return false;
        }

        $data = array(
            'item_number' => $item_number,
            'txn_id' => $txn_id,
            'payment_gross' => $payment_gross,
            'currency_code' => $currency_code,
            'payment_status' => $payment_status,
        );
        $where = array(
            'cf7_paypal_unique' => $cf7_paypal_unique
        );
        $wpdb->update( $wpdb->prefix . 'cf7_paypal', $data, $where);

        if(class_exists('Flamingo_Inbound_Message')) {
            $fla_transaction_row = $wpdb->get_row( "SELECT * FROM " . $wpdb->prefix . 'cf7_paypal' . " WHERE cf7_paypal_unique = '" . $cf7_paypal_unique . "';" );
            $flamingo_id = $fla_transaction_row->flamingo_id;

            $flamingo_meta = get_post_meta($flamingo_id);
            $flamingo_fields = get_post_meta($flamingo_id, '_fields', true);
            foreach ($data as $key => $value) {
                update_post_meta($flamingo_id, '_field_' . $key, $value);
                $flamingo_fields[$key] = NULL;
            }
            update_post_meta($flamingo_id, '_fields', $flamingo_fields);
        }

        if($sendMail == "always" || $sendMail == "never") {
            $to = get_option('admin_email');
    	    $subject = __('New CF7 PayPal Transaction');
    	    $message = sprintf( __('A new Contact Form 7 PayPal Transaction has been done. <a href="%s">Click here.</a>', 'wordpress-cf7-paypal'), 
                                get_admin_url() . 'admin.php?page=cf7-paypal-transactions'
                        );
    	    if(wp_mail($to, $subject, $message )) {
                return true;
            } else {
                return false;
            }
        } else {

            $transaction_row = $wpdb->get_row( "SELECT * FROM " . $wpdb->prefix . 'cf7_paypal' . " WHERE cf7_paypal_unique = '" . $cf7_paypal_unique . "';" );

            $transaction_row_form_data = json_decode($transaction_row->form_data, true);
            $transaction_row_form_data  = array_merge($data, $transaction_row_form_data);
            $mail_1 = get_post_meta($transaction_row_form_data['_wpcf7'], '_mail', true);

            $to = $this->replace_tags( $mail_1['recipient'], $transaction_row_form_data);
            $subject = $this->replace_tags( $mail_1['subject'], $transaction_row_form_data);
            $message = $this->replace_tags( $mail_1['body'], $transaction_row_form_data);

            $attachments = explode(" ", $this->replace_tags( $mail_1['attachments'], $transaction_row_form_data['attachments']) );
            $headers = array_merge( 
                array('From: ' . $this->replace_tags( $mail_1['sender'], $transaction_row_form_data)),
                preg_split("/\r\n|\n|\r/", $mail_1['additional_headers'])
            );

            if($mail_1['use_html'] == true) {
                $headers[] = 'Content-Type: text/html; charset=UTF-8';
            }
            
            wp_mail( $to, $subject, $message, $headers, $attachments );

            $mail_2 = get_post_meta($transaction_row_form_data['_wpcf7'], '_mail_2', true);
            if(!empty($mail_2)) {
                if($mail_2['active']) {
                    $to = $this->replace_tags( $mail_2['recipient'], $transaction_row_form_data);
                    $subject = $this->replace_tags( $mail_2['subject'], $transaction_row_form_data);
                    $message = $this->replace_tags( $mail_2['body'], $transaction_row_form_data);
                    $attachments = explode(" ", $this->replace_tags( $mail_2['attachments'], $transaction_row_form_data['attachments']) );
                    $headers = array_merge( 
                        array('From: ' . $this->replace_tags( $mail_2['sender'], $transaction_row_form_data)),
                        preg_split("/\r\n|\n|\r/", $mail_2['additional_headers'])
                    );

                    if($mail_2['use_html'] == true) {
                        $headers[] = 'Content-Type: text/html; charset=UTF-8';
                    }

                    wp_mail( $to, $subject, $message, $headers, $attachments );
                }
            }
        }

        $url = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
        $url = parse_url($url, PHP_URL_PATH);

        if(count($_GET)) {
            header('Location: '. $url);
            die();
        }

    }

    private function replace_tags($text, $vars)
    {
        if(!is_array($vars)) {
            return $text;
        }

        foreach($vars as $key => $value){
            if(is_array($value)) {
                $tmp = "";
                foreach ($value as $val) {
                    $tmp .= $val . "\r\n"; 
                }
                $value = $tmp;
              // $value = var_export($value, true);
            }
            $text = str_replace('[' . $key . ']', $value, $text);
        }
        return $text;
    }

    /**
     * Store paypal Return parameters in Database
     * ?tx=XXXXX&st=Pending&amt=10%2e00&cc=USD&cm=&item_number=
     * @author Daniel Barenkamp
     * @version 1.0.0
     * @since   1.0.0
     * @link    http://plugins.db-dzine.com
     * @return  bool
     */
    public function payment_cancelled()
    {
        global $wpdb;

        $paypal_unique = isset($_GET['cf7_paypal_unique']) ? $_GET['cf7_paypal_unique'] : '';

        if(empty($paypal_unique)) {
            return false;
        }

        $data = array(
            'cf7_paypal_unique' => $paypal_unique,
        );
        $wpdb->delete( $wpdb->prefix . 'cf7_paypal', $data);
    }


    public function skip_mail($form) 
    {

        $sendMail = $this->get_option('sendMail');

        if($sendMail == "always") {
            return false;
        }

        $submission = WPCF7_Submission::get_instance();

        if(isset($_POST)) {

            if(isset($_POST['paypal_clicked']) && ($_POST['paypal_clicked'] == "yes")) {
                return true;
            }
        }
        return false;
    }

    public function save_contact_form_data($wpcf7) 
    {
        global $wpdb;

        $form_to_DB = WPCF7_Submission::get_instance();

        if($form_to_DB) {
            $formData = $form_to_DB->get_posted_data(); 
            $uploaded_files = $form_to_DB->uploaded_files();
            if(!empty($uploaded_files)) {

                require_once(ABSPATH . "wp-admin" . '/includes/image.php');
                require_once(ABSPATH . "wp-admin" . '/includes/file.php');
                require_once(ABSPATH . "wp-admin" . '/includes/media.php');

                $filesSaved = array();
                foreach ($uploaded_files as $key => $uploaded_file) {
                    $name = basename($uploaded_file);
                    $upload = wp_upload_bits($name, null, file_get_contents($uploaded_file));
                    if(isset($upload['file'])) {
                        $filesSaved[$key] = $upload['file'];
                    }

                }
                $formData['attachments'] = $filesSaved;
            }
        }

        if(isset($_POST['paypal_clicked']) && ($_POST['paypal_clicked'] == "yes")) {

            $data = array(
                'form_data' => json_encode($formData),
                'cf7_paypal_unique' => $_POST['cf7_paypal_unique'],
            );
            $wpdb->insert( $wpdb->prefix . 'cf7_paypal', $data);
        }
    }

    public function flamingo_filter($result)
    {
        global $wpdb;

        $sendMail = $this->get_option('sendMail');

        if(!isset($_POST['paypal_clicked']) || ($_POST['paypal_clicked'] !== "yes")) {
            return false;
        }
            
        if(!empty($result['flamingo_inbound_id'])) {

            $cf7_paypal_unique = $_POST['cf7_paypal_unique'];
            $data = array(
                'flamingo_id' => $result['flamingo_inbound_id'],
            );
            $where = array(
                'cf7_paypal_unique' => $cf7_paypal_unique
            );
            $wpdb->update( $wpdb->prefix . 'cf7_paypal', $data, $where);
        }

        return $result;
    }
}