<?php

/**
 * The file that defines the core plugin class.
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       http://plugins.db-dzine.com
 * @since      1.0.0
 */

class Wordpress_CF7_PayPal
{
    /**
     * The loader that's responsible for maintaining and registering all hooks that power
     * the plugin.
     *
     * @since    1.0.0
     *
     * @var Wordpress_CF7_PayPal_Loader Maintains and registers all hooks for the plugin.
     */
    protected $loader;

    /**
     * The unique identifier of this plugin.
     *
     * @since    1.0.0
     *
     * @var string The string used to uniquely identify this plugin.
     */
    protected $plugin_name;

    /**
     * The current version of the plugin.
     *
     * @since    1.0.0
     *
     * @var string The current version of the plugin.
     */
    protected $version;

    /**
     * Define the core functionality of the plugin.
     *
     * Set the plugin name and the plugin version that can be used throughout the plugin.
     * Load the dependencies, define the locale, and set the hooks for the admin area and
     * the public-facing side of the site.
     *
     * @since    1.0.0
     */
    public function __construct($version)
    {
        $this->plugin_name = 'wordpress-cf7-paypal';
        $this->version = $version;

        $this->load_dependencies();
        $this->set_locale();
        $this->define_admin_hooks();
        $this->define_public_hooks();
    }

    /**
     * Load the required dependencies for this plugin.
     *
     * Include the following files that make up the plugin:
     *
     * - Wordpress_CF7_PayPal_Loader. Orchestrates the hooks of the plugin.
     * - Wordpress_CF7_PayPal_i18n. Defines internationalization functionality.
     * - Wordpress_CF7_PayPal_Admin. Defines all hooks for the admin area.
     * - Wordpress_CF7_PayPal_Public. Defines all hooks for the public side of the site.
     *
     * Create an instance of the loader which will be used to register the hooks
     * with WordPress.
     *
     * @since    1.0.0
     */
    private function load_dependencies()
    {
        /**
         * The class responsible for orchestrating the actions and filters of the
         * core plugin.
         */
        require_once plugin_dir_path(dirname(__FILE__)).'includes/class-wordpress-cf7-paypal-loader.php';

        /**
         * The class responsible for defining internationalization functionality
         * of the plugin.
         */
        require_once plugin_dir_path(dirname(__FILE__)).'includes/class-wordpress-cf7-paypal-i18n.php';

        /**
         * The class responsible for defining all actions that occur in the admin area.
         */
        
        // Include WP's list table class
        if(!class_exists('WP_List_Table')){ 
            require_once( ABSPATH . 'wp-admin/includes/class-wp-screen.php' );//added
            require_once( ABSPATH . 'wp-admin/includes/screen.php' ); 
            require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' ); 
            require_once( ABSPATH . 'wp-admin/includes/template.php' );
        }   

        require_once plugin_dir_path(dirname(__FILE__)).'admin/class-wordpress-cf7-paypal-admin.php';
        require_once plugin_dir_path(dirname(__FILE__)).'admin/class-wordpress-cf7-paypal-transactions.php';

        /**
         * The class responsible for defining all actions that occur in the public-facing
         * side of the site.
         */
        require_once plugin_dir_path(dirname(__FILE__)).'public/class-wordpress-cf7-paypal-public.php';

        $this->loader = new Wordpress_CF7_PayPal_Loader();
    }

    /**
     * Define the locale for this plugin for internationalization.
     *
     * Uses the Wordpress_CF7_PayPal_i18n class in order to set the domain and to register the hook
     * with WordPress.
     *
     * @since    1.0.0
     */
    private function set_locale()
    {
        $this->plugin_i18n = new Wordpress_CF7_PayPal_i18n();

        $this->loader->add_action('plugins_loaded', $this->plugin_i18n, 'load_plugin_textdomain');
    }

    /**
     * Register all of the hooks related to the admin area functionality
     * of the plugin.
     *
     * @since    1.0.0
     */
    private function define_admin_hooks()
    {
        $this->plugin_admin = new Wordpress_CF7_PayPal_Admin($this->get_plugin_name(), $this->get_version());

        $this->loader->add_action('plugins_loaded', $this->plugin_admin, 'load_extensions');
        $this->loader->add_action('init', $this->plugin_admin, 'init');
        $this->loader->add_action('admin_menu', $this->plugin_admin, 'plugin_menu' );
        $this->loader->add_action('wpcf7_admin_init', $this->plugin_admin, 'wpcf7_add_tag_generator_paypal' );
    }

    /**
     * Register all of the hooks related to the public-facing functionality
     * of the plugin.
     *
     * @since    1.0.0
     */
    private function define_public_hooks()
    {
        $this->plugin_public = new Wordpress_CF7_PayPal_Public($this->get_plugin_name(), $this->get_version());

        $this->loader->add_action('wp_enqueue_scripts', $this->plugin_public, 'enqueue_styles');
        $this->loader->add_action('wp_enqueue_scripts', $this->plugin_public, 'enqueue_scripts');

        $this->loader->add_action('init', $this->plugin_public, 'init');
        $this->loader->add_action('wpcf7_init', $this->plugin_public, 'wpcf7_add_shortcode_submit' );
        $this->loader->add_action('wpcf7_before_send_mail', $this->plugin_public, 'save_contact_form_data' );
        $this->loader->add_filter('wpcf7_skip_mail', $this->plugin_public, 'skip_mail');
        if(class_exists('Flamingo_Inbound_Message')) {
            $this->loader->add_action('wpcf7_after_flamingo', $this->plugin_public, 'flamingo_filter');
        }
    }

    /**
     * Run the loader to execute all of the hooks with WordPress.
     *
     * @since    1.0.0
     */
    public function run()
    {
        $this->loader->run();
    }

    /**
     * The name of the plugin used to uniquely identify it within the context of
     * WordPress and to define internationalization functionality.
     *
     * @since     1.0.0
     *
     * @return string The name of the plugin.
     */
    public function get_plugin_name()
    {
        return $this->plugin_name;
    }

    /**
     * The reference to the class that orchestrates the hooks with the plugin.
     *
     * @since     1.0.0
     *
     * @return Wordpress_CF7_PayPal_Loader Orchestrates the hooks of the plugin.
     */
    public function get_loader()
    {
        return $this->loader;
    }

    /**
     * Retrieve the version number of the plugin.
     *
     * @since     1.0.0
     *
     * @return string The version number of the plugin.
     */
    public function get_version()
    {
        return $this->version;
    }
}
